<?php
require_once '../config/database.php';

try {
    $password = 'password123';
    $hash = password_hash($password, PASSWORD_DEFAULT);

    $sql = "INSERT INTO admins (username, password_hash, role) VALUES (:username, :hash, :role)";
    $stmt = $pdo->prepare($sql);

    // Super Admin
    $stmt->execute([':username' => 'super', ':hash' => $hash, ':role' => 'super']);
    
    // Regular Admin
    $stmt->execute([':username' => 'admin', ':hash' => $hash, ':role' => 'admin']);

    echo "Admins created successfully.<br>Username: super / Password: $password<br>Username: admin / Password: $password";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>