<?php
// public/participant/profile.php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

if (!isset($_SESSION['unique_id'])) {
    header("Location: ../login.php");
    exit;
}

$unique_id = $_SESSION['unique_id'];

// Fetch Participant Details
$stmt = $pdo->prepare("SELECT * FROM participants WHERE unique_id = ?");
$stmt->execute([$unique_id]);
$user = $stmt->fetch();

if (!$user) {
    session_destroy();
    header("Location: ../register.php");
    exit;
}

// Fetch Game Scores (Left Join to show all games even if 0 points)
$sql = "SELECT g.game_name, g.max_points, COALESCE(pp.points, 0) as points
        FROM games g
        LEFT JOIN participant_points pp ON g.id = pp.game_id AND pp.participant_id = ?
        ORDER BY g.game_name ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user['id']]);
$gameScores = $stmt->fetchAll();

// Calculate Total Points
$totalPoints = 0;
foreach ($gameScores as $score) {
    $totalPoints += $score['points'];
}

// Check for pending edit requests
$reqStmt = $pdo->prepare("SELECT id FROM profile_edit_requests WHERE participant_id = ? AND status = 'pending'");
$reqStmt->execute([$user['id']]);
$hasPendingRequest = $reqStmt->fetch();

// Generate QR Code URL
$qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=" . urlencode($user['unique_id']);

?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Participant Profile</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF", // Magenta
                        "secondary-accent": "#FF5F1F", // Electric Orange
                        "background-dark": "#050505",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#666666",
                        "input-bg-dark": "#121212",
                        "input-border-dark": "#2a2a2a",
                        "surface-dark": "#0f0f0f",
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1rem",
                        "2xl": "1.5rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
<link rel="stylesheet" href="../css/profile.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-10%] w-[400px] h-[400px] bg-primary-accent rounded-full blur-[130px] opacity-20 pointer-events-none animate-pulse"></div>
<div class="fixed bottom-[20%] left-[-15%] w-[350px] h-[350px] bg-secondary-accent rounded-full blur-[100px] opacity-15 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden z-10">
<header class="w-full flex justify-between items-center px-6 py-4 backdrop-blur-sm sticky top-0 z-50 border-b border-white/5 bg-background-dark/60">
<div class="flex items-center gap-2">
<span class="material-symbols-outlined text-primary-accent text-3xl animate-pulse">token</span>
<span class="font-black italic text-xl tracking-tighter text-white transform -skew-x-6">MAGMA<span class="text-secondary-accent">.</span>25</span>
</div>
<div class="flex items-center gap-4">
    <a href="../logout.php" class="text-xs font-bold text-gray-400 hover:text-white uppercase tracking-widest transition-colors">Logout</a>
    <div class="h-10 w-10 rounded-full bg-gradient-to-tr from-primary-accent to-secondary-accent p-[2px] shadow-[0_0_15px_rgba(255,0,255,0.4)]">
    <img alt="Profile" class="rounded-full bg-black h-full w-full object-cover" src="https://ui-avatars.com/api/?name=<?php echo urlencode($user['name']); ?>&background=random"/>
    </div>
</div>
</header>
<div class="flex-1 w-full max-w-md mx-auto lg:max-w-6xl flex flex-col lg:flex-row gap-6 p-5 pb-20">
<div class="w-full lg:w-1/3 flex flex-col gap-6">
<div class="glass-card p-6 relative overflow-hidden flex flex-col items-center text-center group">
<div class="absolute top-0 left-0 w-full h-[2px] bg-gradient-to-r from-transparent via-primary-accent to-transparent opacity-80"></div>
<div class="bg-white p-3 rounded-xl shadow-[0_0_30px_rgba(255,255,255,0.15)] mb-5 transform group-hover:scale-105 transition-transform duration-500">
<img alt="QR Code" class="w-36 h-36 object-contain mix-blend-multiply" src="<?php echo $qrUrl; ?>"/>
</div>
<h2 class="font-mono text-3xl font-black text-transparent bg-clip-text bg-gradient-to-r from-primary-accent to-white tracking-widest mb-1 text-glow"><?php echo htmlspecialchars($user['unique_id']); ?></h2>
<p class="text-[10px] text-gray-500 uppercase tracking-[0.3em] font-bold mb-8">Participant Identity</p>
<div class="w-full space-y-4 text-left border-t border-white/10 pt-6">
<div class="relative pl-4 border-l-2 border-primary-accent/50">
<p class="text-[10px] text-secondary-accent font-bold uppercase tracking-wider mb-0.5">Full Name</p>
<p class="text-white font-bold text-lg leading-tight truncate"><?php echo htmlspecialchars($user['name']); ?></p>
</div>
<div class="grid grid-cols-2 gap-4">
<div class="pl-4 border-l-2 border-white/10">
<p class="text-[10px] text-gray-500 font-bold uppercase tracking-wider mb-0.5">College</p>
<p class="text-gray-200 font-medium text-sm truncate"><?php echo htmlspecialchars($user['college']); ?></p>
</div>
<div class="pl-4 border-l-2 border-white/10">
<p class="text-[10px] text-gray-500 font-bold uppercase tracking-wider mb-0.5">Dept</p>
<p class="text-gray-200 font-medium text-sm truncate"><?php echo htmlspecialchars($user['department']); ?></p>
</div>
</div>
<div class="grid grid-cols-2 gap-4">
<div class="pl-4 border-l-2 border-white/10">
<p class="text-[10px] text-gray-500 font-bold uppercase tracking-wider mb-0.5">Year</p>
<p class="text-gray-200 font-medium text-sm"><?php echo htmlspecialchars($user['year']); ?> Year</p>
</div>
<div class="pl-4 border-l-2 border-white/10">
<p class="text-[10px] text-gray-500 font-bold uppercase tracking-wider mb-0.5">Phone</p>
<p class="text-gray-200 font-medium text-sm truncate"><?php echo htmlspecialchars($user['phone']); ?></p>
</div>
</div>
</div>
<div class="w-full mt-8 space-y-3">
<?php if ($hasPendingRequest): ?>
<button class="w-full h-10 rounded-xl bg-transparent border border-white/5 text-gray-600 text-[10px] font-bold tracking-widest uppercase cursor-not-allowed flex items-center justify-center gap-2 opacity-60" disabled="">
<span class="material-symbols-outlined text-base animate-spin" style="animation-duration: 3s;">sync</span>
                        Edit Request Pending
                     </button>
<?php else: ?>
<a href="edit_profile.php" class="w-full h-12 rounded-xl bg-white/5 border border-white/10 hover:bg-white/10 hover:border-primary-accent/50 transition-all text-xs font-bold uppercase tracking-widest text-white flex items-center justify-center gap-2 group/btn">
<span class="material-symbols-outlined text-lg text-gray-400 group-hover/btn:text-primary-accent transition-colors">edit_square</span>
                        Edit Profile
                     </a>
<?php endif; ?>
<a href="change_password.php" class="w-full h-12 rounded-xl bg-white/5 border border-white/10 hover:bg-white/10 hover:border-secondary-accent/50 transition-all text-xs font-bold uppercase tracking-widest text-white flex items-center justify-center gap-2 group/btn">
<span class="material-symbols-outlined text-lg text-gray-400 group-hover/btn:text-secondary-accent transition-colors">lock_reset</span>
                        Change Password
                     </a>
<button onclick="window.print()" class="w-full h-12 rounded-xl bg-gradient-to-r from-secondary-accent to-orange-600 hover:shadow-[0_0_20px_rgba(255,95,31,0.4)] hover:-translate-y-0.5 active:translate-y-0 transition-all text-xs font-black uppercase tracking-widest text-white flex items-center justify-center gap-2 shadow-lg relative overflow-hidden">
<div class="absolute inset-0 bg-white/20 translate-x-[-100%] hover:translate-x-[100%] transition-transform duration-700"></div>
<span class="material-symbols-outlined text-lg">download</span>
                        Download QR Card (PDF)
                     </button>
</div>
</div>
</div>
<div class="w-full lg:w-2/3 flex flex-col gap-6">
<div class="flex items-end justify-between px-1 lg:hidden">
<h3 class="text-2xl font-black italic text-white uppercase transform -skew-x-6">Performance</h3>
<span class="inline-block px-2 py-1 rounded bg-primary-accent/20 border border-primary-accent/40 text-[10px] font-bold text-primary-accent animate-pulse">LIVE</span>
</div>
<div class="w-full p-6 lg:p-8 rounded-2xl bg-gradient-to-br from-primary-accent/20 via-purple-900/10 to-background-dark border border-primary-accent/30 backdrop-blur-md relative overflow-hidden group hover:border-primary-accent/60 transition-colors duration-500">
<div class="absolute -right-20 -top-20 w-64 h-64 bg-primary-accent/20 rounded-full blur-[80px] group-hover:bg-primary-accent/30 transition-colors duration-500"></div>
<div class="flex flex-row justify-between items-center relative z-10">
<div class="flex flex-col">
<div class="flex items-center gap-2 mb-2">
<span class="material-symbols-outlined text-secondary-accent">trophy</span>
<h3 class="text-gray-300 font-bold text-sm uppercase tracking-[0.2em]">Total Score</h3>
</div>
<p class="text-xs text-white/50 max-w-[150px]">Your current standing in MAGMA 2025 events.</p>
</div>
<div class="text-right flex flex-col items-end">
<span class="block text-6xl lg:text-7xl font-black text-white drop-shadow-[0_0_25px_rgba(255,0,255,0.6)] leading-none italic"><?php echo number_format($totalPoints); ?></span>
<div class="flex items-center gap-1 mt-2 bg-green-500/10 px-2 py-1 rounded border border-green-500/20">
<span class="material-symbols-outlined text-green-400 text-sm">trending_up</span>
<span class="text-green-400 text-[10px] font-bold uppercase tracking-wider">Active</span>
</div>
</div>
</div>
</div>
<div class="flex-1 glass-card flex flex-col overflow-hidden">
<div class="p-5 border-b border-white/10 flex items-center justify-between bg-white/5">
<div class="flex items-center gap-3">
<div class="p-2 rounded bg-secondary-accent/20 border border-secondary-accent/30">
<span class="material-symbols-outlined text-secondary-accent text-xl">sports_esports</span>
</div>
<h3 class="font-bold text-white uppercase tracking-wider text-sm">Game Performance</h3>
</div>
<button class="text-gray-500 hover:text-white transition-colors">
<span class="material-symbols-outlined">filter_list</span>
</button>
</div>
<div class="overflow-x-auto">
<table class="w-full text-left border-collapse">
<thead>
<tr class="bg-black/20">
<th class="p-4 pl-6 text-[10px] font-black text-gray-500 uppercase tracking-widest">Game Name</th>
<th class="p-4 text-[10px] font-black text-gray-500 uppercase tracking-widest text-center">Max Pts</th>
<th class="p-4 pr-6 text-[10px] font-black text-gray-500 uppercase tracking-widest text-right">Scored</th>
</tr>
</thead>
<tbody class="divide-y divide-white/5 text-sm">
<?php if (count($gameScores) > 0): ?>
    <?php foreach ($gameScores as $game): ?>
    <tr class="hover:bg-white/5 transition-colors group">
    <td class="p-4 pl-6 font-bold text-white group-hover:text-primary-accent transition-colors flex items-center gap-3">
    <div class="w-2 h-2 rounded-full bg-primary-accent shadow-[0_0_8px_#FF00FF]"></div>
                                        <?php echo htmlspecialchars($game['game_name']); ?>
                                    </td>
    <td class="p-4 text-center text-gray-500 font-mono text-xs"><?php echo $game['max_points']; ?></td>
    <td class="p-4 pr-6 text-right font-black text-secondary-accent text-lg drop-shadow-[0_0_8px_rgba(255,95,31,0.3)]"><?php echo $game['points']; ?></td>
    </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr><td colspan="3" class="p-6 text-center text-gray-500">No games available yet.</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
<div class="p-3 border-t border-white/5 bg-black/20 flex justify-center items-center gap-2">
<span class="w-1.5 h-1.5 rounded-full bg-primary-accent"></span>
<span class="w-1.5 h-1.5 rounded-full bg-white/20"></span>
<span class="w-1.5 h-1.5 rounded-full bg-white/20"></span>
</div>
</div>
</div>
</div>
</div>

</body></html>