<?php
require_once '../config/database.php';
header('Content-Type: application/json');

$game_id = filter_input(INPUT_GET, 'game_id', FILTER_VALIDATE_INT);

if (!$game_id) {
    echo json_encode([]);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT p.name, pp.points 
        FROM participant_points pp
        JOIN participants p ON pp.participant_id = p.id
        WHERE pp.game_id = ?
        ORDER BY pp.points DESC
        LIMIT 3
    ");
    $stmt->execute([$game_id]);
    $leaderboard = $stmt->fetchAll();
    echo json_encode($leaderboard);
} catch (PDOException $e) {
    echo json_encode([]);
}
?>