(function() {
    const Toast = {
        init() {
            if (document.getElementById('toast-container')) return;
            
            this.container = document.createElement('div');
            this.container.id = 'toast-container';
            this.container.className = 'fixed top-4 right-4 z-[100] flex flex-col gap-3 pointer-events-none';
            document.body.appendChild(this.container);
            
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideIn {
                    from { transform: translateX(100%); opacity: 0; }
                    to { transform: translateX(0); opacity: 1; }
                }
                @keyframes fadeOut {
                    from { opacity: 1; }
                    to { opacity: 0; }
                }
                .toast-enter { animation: slideIn 0.4s cubic-bezier(0.16, 1, 0.3, 1) forwards; }
                .toast-exit { animation: fadeOut 0.3s ease-in forwards; }
            `;
            document.head.appendChild(style);
        },

        show(message, type = 'success') {
            this.init();

            const toast = document.createElement('div');
            toast.className = `pointer-events-auto min-w-[300px] max-w-sm p-4 rounded-xl shadow-2xl border backdrop-blur-xl flex items-start gap-3 toast-enter transition-all duration-300 transform translate-x-0`;
            
            if (type === 'success') {
                toast.classList.add('bg-green-950/90', 'border-green-500/30', 'text-green-100');
                toast.innerHTML = `<span class="material-symbols-outlined text-green-400 mt-0.5">check_circle</span>`;
            } else if (type === 'error') {
                toast.classList.add('bg-red-950/90', 'border-red-500/30', 'text-red-100');
                toast.innerHTML = `<span class="material-symbols-outlined text-red-400 mt-0.5">error</span>`;
            } else {
                toast.classList.add('bg-gray-900/90', 'border-gray-600/30', 'text-white');
                toast.innerHTML = `<span class="material-symbols-outlined text-gray-400 mt-0.5">info</span>`;
            }

            const content = document.createElement('div');
            content.className = 'flex-1';
            
            const text = document.createElement('p');
            text.className = 'text-sm font-medium leading-tight';
            text.textContent = message;
            content.appendChild(text);
            toast.appendChild(content);

            const closeBtn = document.createElement('button');
            closeBtn.className = 'text-white/40 hover:text-white transition-colors -mt-1 -mr-1';
            closeBtn.innerHTML = '<span class="material-symbols-outlined text-lg">close</span>';
            closeBtn.onclick = () => this.dismiss(toast);
            toast.appendChild(closeBtn);

            this.container.appendChild(toast);

            setTimeout(() => this.dismiss(toast), 5000);
        },

        dismiss(toast) {
            if (toast.classList.contains('toast-exit')) return;
            toast.classList.remove('toast-enter');
            toast.classList.add('toast-exit');
            toast.addEventListener('animationend', () => {
                if (toast.parentElement) toast.remove();
            });
        }
    };

    window.showToast = (msg, type) => Toast.show(msg, type);
})();