<?php
require_once '../config/database.php';

if (isset($_SESSION['unique_id'])) {
    header("Location: participant/profile.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_input = trim($_POST['unique_id'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($login_input) || empty($password)) {
        $error = "Please enter Unique ID or Phone and Password.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM participants WHERE unique_id = ? OR phone = ?");
        $stmt->execute([$login_input, $login_input]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password_hash'])) {
            session_regenerate_id(true);
            $_SESSION['unique_id'] = $user['unique_id'];
            header("Location: participant/profile.php");
            exit;
        } else {
            $error = "Invalid Unique ID/Phone or Password.";
        }
    }
}
?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Event Login</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF","secondary-accent": "#00FFFF","background-dark": "#0a0a0a",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#888888",
                        "input-bg-dark": "#161616",
                        "input-border-dark": "#333333",
                        "surface-dark": "#121212",
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1.5rem",
                        "full": "9999px"
                    },
                    animation: {
                        'fade-in-up': 'fadeInUp 0.8s ease-out forwards',
                        'slide-in': 'slideIn 0.5s ease-out forwards',
                    },
                    keyframes: {
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(20px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        slideIn: {
                            '0%': { opacity: '0', transform: 'translateX(-20px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        }
                    }
                },
            },
        }
    </script>
<link rel="stylesheet" href="css/login.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-20%] w-[500px] h-[500px] bg-primary-accent rounded-full blur-[120px] opacity-20 pointer-events-none mix-blend-screen animate-pulse"></div>
<div class="fixed bottom-[-10%] left-[-20%] w-[400px] h-[400px] bg-secondary-accent rounded-full blur-[100px] opacity-10 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden justify-between z-10">
<div class="flex-1 flex flex-col items-center justify-center px-6 py-8 w-full max-w-md mx-auto animate-fade-in-up">
<div class="w-full flex flex-col items-center mb-12 relative group">
<div class="relative mb-6">
<div class="absolute inset-0 bg-secondary-accent blur-lg opacity-40 rounded-full scale-110 group-hover:scale-125 transition-transform duration-500"></div>
<div class="relative w-24 h-24 bg-gradient-to-br from-primary-accent to-purple-600 rounded-2xl rotate-3 flex items-center justify-center shadow-2xl shadow-primary-accent/40 border border-white/10 z-10">
<span class="material-symbols-outlined text-5xl text-white drop-shadow-md -rotate-3">flash_on</span>
</div>
<div class="absolute top-0 left-0 w-24 h-24 border-2 border-secondary-accent rounded-2xl -rotate-6 z-0 opacity-60"></div>
</div>
<h1 class="text-white tracking-tighter text-6xl font-black leading-none text-center italic uppercase drop-shadow-lg text-glow transform -skew-x-6">
                MAGMA<span class="text-primary-accent">.</span>25
            </h1>
<div class="h-1 w-20 bg-gradient-to-r from-transparent via-secondary-accent to-transparent mt-4 mb-2"></div>
<h2 class="text-gray-300 text-lg font-bold tracking-[0.2em] mt-2 text-center uppercase">
                Feel the Energy
            </h2>
</div>

<form id="loginForm" method="POST" action="login.php" class="w-full space-y-5 backdrop-blur-sm bg-surface-dark/80 p-6 rounded-3xl border border-white/5 shadow-2xl">
    <?php if ($error): ?>
        <div class="p-3 mb-4 text-sm text-red-500 bg-red-100/10 border border-red-500/50 rounded-lg">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>

<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 100ms; opacity: 0;">
<label class="sr-only" for="unique_id">UNIQUE ID / PHONE</label>
<div class="relative flex items-center">
<div class="absolute left-4 top-0 bottom-0 flex items-center justify-center z-10">
<span class="material-symbols-outlined text-gray-400 group-focus-within:text-white transition-colors">person</span>
</div>
<input class="form-input flex w-full min-w-0 resize-none overflow-hidden rounded-full text-white bg-transparent border border-gray-700 h-14 placeholder:text-gray-600 pl-14 pr-4 text-lg font-bold tracking-wide focus:outline-0 focus:ring-0 focus:border-white transition-all duration-200" id="unique_id" name="unique_id" placeholder="UNIQUE ID / PHONE" type="text" value="<?php echo htmlspecialchars($_POST['unique_id'] ?? ''); ?>" required />
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 200ms; opacity: 0;">
<label class="sr-only" for="password">Password</label>
<div class="relative flex items-center">
<div class="absolute left-4 top-0 bottom-0 flex items-center justify-center z-10">
<span class="material-symbols-outlined text-gray-400 group-focus-within:text-white transition-colors">lock</span>
</div>
<input class="form-input flex w-full min-w-0 resize-none overflow-hidden rounded-full text-white bg-transparent border border-gray-700 h-14 placeholder:text-gray-600 pl-14 pr-12 text-lg font-bold tracking-wide focus:outline-0 focus:ring-0 focus:border-white transition-all duration-200" id="password" name="password" placeholder="PASSWORD" type="password" required />
<button class="absolute right-4 top-0 bottom-0 flex items-center justify-center text-gray-500 hover:text-white transition-colors" type="button" onclick="const p = document.getElementById('password'); p.type = p.type === 'password' ? 'text' : 'password';">
<span class="material-symbols-outlined text-xl">visibility</span>
</button>
</div>
</div>
<button id="submitBtn" type="submit" class="relative w-full group cursor-pointer h-14 mt-4 overflow-hidden rounded-full bg-primary-accent transition-all duration-300 hover:shadow-[0_0_30px_rgba(255,0,255,0.6)] active:scale-[0.98] animate-slide-in" style="animation-delay: 300ms; opacity: 0;">
<div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/20 to-transparent translate-x-[-100%] group-hover:translate-x-[100%] transition-transform duration-700 ease-in-out"></div>
<div id="btnText" class="flex items-center justify-center h-full w-full transition-opacity duration-200">
<span class="text-black text-xl font-black uppercase tracking-wider mr-2">Login</span>
<span class="material-symbols-outlined text-black font-bold">arrow_forward</span>
</div>
<div id="btnSpinner" class="absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-200 pointer-events-none">
    <svg class="animate-spin h-8 w-8 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
    </svg>
</div>
</button>
</form>
</div>
<div class="w-full py-8 text-center z-10">
<p class="text-gray-500 text-sm font-medium uppercase tracking-wide">
            Don't have access?
        </p>
<a class="inline-block mt-2 text-secondary-accent font-bold uppercase tracking-wider hover:text-white transition-colors border-b-2 border-transparent hover:border-secondary-accent pb-1" href="register.php">
            Register Now
        </a>
</div>
</div>
<script>
    document.getElementById('loginForm').addEventListener('submit', function() {
        const btn = document.getElementById('submitBtn');
        const text = document.getElementById('btnText');
        const spinner = document.getElementById('btnSpinner');
        
        text.classList.add('opacity-0');
        spinner.classList.remove('opacity-0');
        btn.style.pointerEvents = 'none';
    });
</script>
</body></html>