<?php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

// Access Control
if (!isset($_SESSION['admin_id'])) {
    header("Location: ../super_login.php");
    exit;
}
if (($_SESSION['role'] ?? '') !== 'super') {
    die('<div class="container mt-5"><div class="alert alert-danger">Access Denied. Super Admin only. <a href="dashboard.php">Back</a></div></div>');
}

$message = '';
$editMode = false;
$editAdmin = null;

// Handle Delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    // Prevent deleting self
    if ($id == $_SESSION['admin_id']) {
        $message = "Error: You cannot delete your own account.";
    } else {
        $stmt = $pdo->prepare("DELETE FROM admins WHERE id = ?");
        $stmt->execute([$id]);
        header("Location: manage_admins.php?msg=deleted");
        exit;
    }
}

// Handle Edit Mode
if (isset($_GET['edit'])) {
    $editMode = true;
    $stmt = $pdo->prepare("SELECT * FROM admins WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $editAdmin = $stmt->fetch();
}

// Handle Form Submission (Add/Update)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $role = $_POST['role'];
    $admin_id = $_POST['admin_id'] ?? null;
    // Only regular admins get a game assigned; Super admins do not.
    $game_id = ($role === 'admin' && !empty($_POST['game_id'])) ? $_POST['game_id'] : null;

    if (empty($username) || (empty($admin_id) && empty($password))) {
        $message = "Username and Password are required for new admins.";
    } else {
        try {
            if ($admin_id) {
                // Update
                if (!empty($password)) {
                    $password_hash = password_hash($password, PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("UPDATE admins SET username = ?, password_hash = ?, role = ?, game_id = ? WHERE id = ?");
                    $stmt->execute([$username, $password_hash, $role, $game_id, $admin_id]);
                } else {
                    $stmt = $pdo->prepare("UPDATE admins SET username = ?, role = ?, game_id = ? WHERE id = ?");
                    $stmt->execute([$username, $role, $game_id, $admin_id]);
                }
                $message = "Admin updated successfully!";
                $editMode = false;
                $editAdmin = null;
            } else {
                // Insert
                $password_hash = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("INSERT INTO admins (username, password_hash, role, game_id) VALUES (?, ?, ?, ?)");
                $stmt->execute([$username, $password_hash, $role, $game_id]);
                $message = "Admin added successfully!";
            }
        } catch (PDOException $e) {
            if ($e->getCode() == 23000) {
                $message = "Error: Username already exists.";
            } else {
                $message = "Database error: " . $e->getMessage();
            }
        }
    }
}

// Fetch All Admins
$admins = $pdo->query("SELECT a.*, g.game_name FROM admins a LEFT JOIN games g ON a.game_id = g.id ORDER BY a.created_at DESC")->fetchAll();

// Fetch Games for Dropdown
$games = $pdo->query("SELECT * FROM games ORDER BY game_name ASC")->fetchAll();

include '../../views/header.php';
?>
<!-- Reusing manage_games.css for layout consistency -->
<link rel="stylesheet" href="../css/manage_games.css">

<div>
    <div class="row">
        <!-- Form Section -->
        <div class="col-md-4 mb-4">
            <div class="card shadow-soft">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><?php echo $editMode ? 'Edit Admin' : 'Add New Admin'; ?></h5>
                </div>
                <div class="card-body">
                    <?php if ($message): ?>
                        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                    <?php endif; ?>
                    
                    <form method="POST" action="manage_admins.php">
                        <?php if ($editMode): ?>
                            <input type="hidden" name="admin_id" value="<?php echo $editAdmin['id']; ?>">
                        <?php endif; ?>
                        
                        <div class="mb-3">
                            <label class="form-label">Username</label>
                            <input type="text" name="username" class="form-control" value="<?php echo $editMode ? htmlspecialchars($editAdmin['username']) : ''; ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control" <?php echo $editMode ? '' : 'required'; ?>>
                            <?php if ($editMode): ?>
                                <div class="form-text">Leave blank to keep current password.</div>
                            <?php endif; ?>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Role</label>
                            <select name="role" class="form-select">
                                <option value="admin" <?php echo ($editMode && $editAdmin['role'] === 'admin') ? 'selected' : ''; ?>>Admin</option>
                                <option value="super" <?php echo ($editMode && $editAdmin['role'] === 'super') ? 'selected' : ''; ?>>Super Admin</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Assigned Game (For Admins)</label>
                            <select name="game_id" class="form-select">
                                <option value="">-- None --</option>
                                <?php foreach ($games as $game): ?>
                                    <option value="<?php echo $game['id']; ?>" <?php echo ($editMode && $editAdmin['game_id'] == $game['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($game['game_name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success"><?php echo $editMode ? 'Update Admin' : 'Add Admin'; ?></button>
                            <?php if ($editMode): ?>
                                <a href="manage_admins.php" class="btn btn-secondary">Cancel</a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- List Section -->
        <div class="col-md-8">
            <div class="table-container shadow-soft">
                <h4 class="mb-3">Existing Admins</h4>
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Role</th>
                            <th>Assigned Game</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($admins as $admin): ?>
                        <tr>
                            <td><?php echo $admin['id']; ?></td>
                            <td><?php echo htmlspecialchars($admin['username']); ?></td>
                            <td>
                                <?php if($admin['role'] === 'super'): ?>
                                    <span class="badge bg-danger">Super Admin</span>
                                <?php else: ?>
                                    <span class="badge bg-primary">Admin</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($admin['game_name']): ?>
                                    <span class="badge bg-info text-dark"><?php echo htmlspecialchars($admin['game_name']); ?></span>
                                <?php else: ?>
                                    <span class="text-muted small">None</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="manage_admins.php?edit=<?php echo $admin['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                                <?php if($admin['id'] != $_SESSION['admin_id']): ?>
                                    <a href="manage_admins.php?delete=<?php echo $admin['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?');">Delete</a>
                                <?php else: ?>
                                    <button class="btn btn-sm btn-secondary" disabled>Delete</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../../views/footer.php'; ?>