# Website Pages & UI Overview

This document lists all the visible pages in the College Event Management System and describes their user interface and functionality.

## Public & Participant Interface

### 1. Landing Page (`public/index.php`)
- **Purpose:** Main entry point for all users.
- **UI Layout:**
  - Centered "EventSys" branding and welcome message.
  - **Action Buttons:**
    - "Student Registration" (Primary Blue Button)
    - "Game Controller" (Outline Gray Button)
    - "Super Admin" (Outline Red Button)

### 2. Student Registration (`public/register.php`)
- **Purpose:** New participant sign-up.
- **UI Layout:**
  - Centered card with soft shadows.
  - **Form Fields:** Full Name, College Name, Year (Dropdown 1-4), Department, Phone Number, Password.
  - **Action:** Large "Register" button.

### 3. Participant Profile (`public/profile.php`)
- **Purpose:** Student dashboard to view stats and QR code.
- **UI Layout:**
  - **Left Column:**
    - Profile Card containing the **QR Code** (generated dynamically).
    - **Unique ID** displayed in a large, bold monospace font.
    - Personal details list (College, Dept, Year, Phone).
    - Buttons: "Edit Profile" (or "Edit Pending") and "Download QR Card (PDF)".
  - **Right Column:**
    - **Total Score Card:** Gradient blue background with trophy icon.
    - **Game Performance Table:** Lists Game Name, Max Points, and Points Scored.

### 4. Leaderboard (`public/ranking.php`)
- **Purpose:** Public ranking of participants.
- **UI Layout:**
  - **Search Bar:** Centered at the top to filter by name.
  - **Table:** Responsive table listing Rank, Participant Name, College, Department, and Total Points.
  - **Visuals:** Top 3 ranks have Gold, Silver, and Bronze circular badges.

### 5. Edit Profile Request (`app/edit_profile.php` / `public/edit_profile.php`)
- **Purpose:** Form for participants to request changes to their data.
- **UI Layout:**
  - Form pre-filled with current user data.
  - If a request is already pending, a yellow warning alert is shown instead of the form.

---

## Admin Portals

### 6. Game Controller Login (`public/game_login.php`)
- **Purpose:** Login for regular admins (Game Controllers).
- **UI Layout:**
  - Dark-themed card (Black/Dark Gray header).
  - Username and Password fields.

### 7. Super Admin Login (`app/super_login.php` / `public/super_login.php`)
- **Purpose:** Login for Super Admins.
- **UI Layout:**
  - Red-themed card to distinguish high-level access.

### 8. General Admin Login (`public/admin_login.php`)
- **Purpose:** Routing login page (redirects based on role).
- **UI Layout:**
  - Dark-themed card.

---

## Admin Dashboards & Tools

### 9. Game Controller Dashboard (`public/admin_dashboard.php`)
- **Purpose:** Hub for regular admins.
- **UI Layout:**
  - **Stats Tiles:** Total Participants, Total Games, Total Points Assigned.
  - **Main Action:** Large, prominent card linking to "Scan QR & Assign Points" with a camera icon.

### 10. Super Admin Dashboard (`public/super_admin_dashboard.php`)
- **Purpose:** Hub for system administrators.
- **UI Layout:**
  - **Stats Tiles:** Same as regular dashboard.
  - **System Management Grid:** Links to Manage Games, View Logs, Manage Admins, Profile Requests, and System Health.
  - **Admin Overview Table:** A list of all admin users, their roles, and assigned games.
  - **Alerts:** Shows database error warnings if schema is outdated.

### 11. QR Scanner & Point Assignment (`public/scan.php`)
- **Purpose:** The core tool for assigning points.
- **UI Layout:**
  - **Header:** Visual indicator showing if in "Super Admin Mode" or "Managing [Game Name]".
  - **Stats:** Live counter showing "Scans Today".
  - **Leaderboard Widget:** Shows top 3 participants for the selected game.
  - **Controls:** Game Dropdown (restricted for regular admins), Points Input, Note Input.
  - **Tabs:** Switch between "Scan QR" (Camera feed) and "Manual Entry" (Text input).
  - **Feedback:** Success/Error alerts appear at the top with an **Undo** button for mistakes.

### 12. Manage Games (`public/manage_games.php`)
- **Purpose:** CRUD for Games.
- **UI Layout:**
  - **Left:** Form to Add/Edit a game (Name, Max Points).
  - **Right:** List of existing games with Edit/Delete buttons.

### 13. Manage Admins (`public/manage_admins.php`)
- **Purpose:** CRUD for Admin Users.
- **UI Layout:**
  - **Left:** Form to Add/Edit Admin (Username, Password, Role, Assigned Game).
  - **Right:** List of admins showing their role (Badge) and assigned game.

### 14. Manage Requests (`app/manage_requests.php`)
- **Purpose:** Approve/Reject participant profile changes.
- **UI Layout:**
  - Table listing the Participant, the Requested Changes (Old vs New), and Date.
  - **Actions:** Green "Approve" and Red "Reject" buttons.

### 15. Activity Logs (`public/admin_logs.php`)
- **Purpose:** Audit trail of point assignments.
- **UI Layout:**
  - **Search Bar:** Filter logs by admin, participant, or game.
  - **Table:** Timestamp, Admin Name, Participant Name, Game, Points (+Badge), Note, IP Address.
  - **Pagination:** Page numbers at the bottom.

### 16. System Health (`public/health_check.php`)
- **Purpose:** Diagnostics.
- **UI Layout:**
  - **Server Environment Card:** PHP/DB versions.
  - **Database Integrity Card:** Status of connection and required tables (Green Check / Red X).
  - **Error Logs:** Scrollable black box showing the last 20 lines of the PHP error log.