<?php
// public/participant/change_password.php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

if (!isset($_SESSION['unique_id'])) {
    header("Location: ../login.php");
    exit;
}

$unique_id = $_SESSION['unique_id'];
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = "All fields are required.";
    } elseif ($new_password !== $confirm_password) {
        $error = "New passwords do not match.";
    } elseif (strlen($new_password) < 6) {
        $error = "New password must be at least 6 characters.";
    } else {
        // Fetch current user data
        $stmt = $pdo->prepare("SELECT id, password_hash FROM participants WHERE unique_id = ?");
        $stmt->execute([$unique_id]);
        $user = $stmt->fetch();

        if ($user && password_verify($current_password, $user['password_hash'])) {
            // Update password
            $new_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $updateStmt = $pdo->prepare("UPDATE participants SET password_hash = ? WHERE id = ?");
            if ($updateStmt->execute([$new_hash, $user['id']])) {
                $message = "Password updated successfully.";
            } else {
                $error = "Failed to update password.";
            }
        } else {
            $error = "Incorrect current password.";
        }
    }
}
?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Change Password</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF", // Magenta
                        "secondary-accent": "#FF5F1F", // Electric Orange
                        "background-dark": "#050505",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#666666",
                        "input-bg-dark": "#121212",
                        "input-border-dark": "#2a2a2a",
                        "surface-dark": "#0f0f0f",
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1rem",
                        "2xl": "1.5rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
<link rel="stylesheet" href="../css/change_password.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-10%] w-[400px] h-[400px] bg-primary-accent rounded-full blur-[130px] opacity-20 pointer-events-none animate-pulse"></div>
<div class="fixed bottom-[5%] left-[-15%] w-[350px] h-[350px] bg-secondary-accent rounded-full blur-[100px] opacity-15 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden z-10">
<div class="flex-1 flex flex-col items-center justify-center px-5 py-6 w-full max-w-lg mx-auto">
<div class="w-full flex flex-col items-center mb-8 relative group">
<div class="relative mb-4">
<div class="absolute inset-0 bg-secondary-accent blur-xl opacity-30 rounded-full scale-110 group-hover:scale-125 transition-transform duration-500"></div>
<div class="relative w-20 h-20 bg-gradient-to-br from-primary-accent to-purple-800 rounded-2xl -rotate-3 flex items-center justify-center shadow-xl border border-white/10 z-10">
<span class="material-symbols-outlined text-4xl text-white drop-shadow-md rotate-3">lock_reset</span>
</div>
</div>
<h1 class="text-white tracking-tighter text-5xl font-black leading-none text-center italic uppercase drop-shadow-lg text-glow transform -skew-x-6">
                    MAGMA<span class="text-secondary-accent">.</span>25
                </h1>
<div class="h-1 w-16 bg-gradient-to-r from-transparent via-secondary-accent to-transparent mt-3 mb-2"></div>
<p class="text-gray-400 text-xs font-bold tracking-[0.3em] mt-1 text-center uppercase">
                    Change Password
                </p>
</div>
<div class="w-full space-y-4 backdrop-blur-md bg-surface-dark/70 p-6 rounded-2xl border border-white/10 shadow-2xl relative overflow-hidden transition-all duration-300">
<div class="absolute top-0 left-0 w-full h-[2px] bg-gradient-to-r from-transparent via-primary-accent to-transparent opacity-50"></div>
<?php if ($message): ?>
    <div class="p-3 mb-4 text-sm text-green-500 bg-green-100/10 border border-green-500/50 rounded-lg">
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="p-3 mb-4 text-sm text-red-500 bg-red-100/10 border border-red-500/50 rounded-lg">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<form class="space-y-4" method="POST">
<?php foreach (['current_password' => 'Current Password', 'new_password' => 'New Password', 'confirm_password' => 'Confirm Password'] as $field => $label): ?>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="<?php echo $field; ?>"><?php echo $label; ?></label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-xl">lock</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="<?php echo $field; ?>" name="<?php echo $field; ?>" placeholder="<?php echo strtoupper($label); ?>" type="password" required/>
<button class="absolute right-0 top-0 bottom-0 w-12 flex items-center justify-center text-gray-500 hover:text-white transition-colors" type="button" onclick="const p = document.getElementById('<?php echo $field; ?>'); p.type = p.type === 'password' ? 'text' : 'password';">
<span class="material-symbols-outlined text-xl">visibility</span>
</button>
</div>
</div>
<?php endforeach; ?>

<button class="relative w-full group cursor-pointer h-14 mt-2 overflow-hidden rounded-xl bg-gradient-to-r from-primary-accent to-purple-600 transition-all duration-300 hover:shadow-[0_0_30px_rgba(255,0,255,0.4)] active:scale-[0.98] border border-white/10" type="submit">
<div class="absolute inset-0 bg-white/20 translate-y-full group-hover:translate-y-0 transition-transform duration-500 ease-out"></div>
<div class="flex items-center justify-center h-full w-full relative z-10">
<span class="text-white text-lg font-black uppercase tracking-widest mr-2">Update Password</span>
<span class="material-symbols-outlined text-white font-bold group-hover:translate-x-1 transition-transform">check_circle</span>
</div>
</button>
</form>
</div>
<div class="w-full py-6 text-center z-10">
<a class="inline-flex items-center text-gray-400 text-xs font-bold uppercase tracking-widest hover:text-white transition-colors group pb-1 opacity-70 hover:opacity-100" href="profile.php">
<span class="material-symbols-outlined text-sm mr-2 group-hover:-translate-x-1 transition-transform">arrow_back</span>
                    Back to Profile
                </a>
</div>
</div>
</div>
</body></html>