<?php
require_once '../config/database.php';

try {
    echo "<h3>Starting Database Migration...</h3>";

    // 1. Ensure assigned_game_id exists
    $colCheck = $pdo->query("SHOW COLUMNS FROM admins LIKE 'assigned_game_id'");
    if (!$colCheck->fetch()) {
        $pdo->exec("ALTER TABLE admins ADD COLUMN assigned_game_id INT DEFAULT NULL");
        echo "✅ Created column 'assigned_game_id'.<br>";
    } else {
        echo "ℹ️ Column 'assigned_game_id' already exists.<br>";
    }

    // 2. Check if old game_id exists
    $colCheckOld = $pdo->query("SHOW COLUMNS FROM admins LIKE 'game_id'");
    if ($colCheckOld->fetch()) {
        // Migrate data: Copy game_id to assigned_game_id if assigned_game_id is empty
        $pdo->exec("UPDATE admins SET assigned_game_id = game_id WHERE (assigned_game_id IS NULL OR assigned_game_id = 0) AND game_id IS NOT NULL");
        echo "✅ Migrated data from 'game_id' to 'assigned_game_id'.<br>";

        // Attempt to drop Foreign Key on game_id if it exists
        $stmt = $pdo->prepare("
            SELECT CONSTRAINT_NAME 
            FROM information_schema.KEY_COLUMN_USAGE 
            WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'admins' AND COLUMN_NAME = 'game_id' AND REFERENCED_TABLE_NAME IS NOT NULL
        ");
        $stmt->execute([$dbName]);
        $fk = $stmt->fetchColumn();

        if ($fk) {
            $pdo->exec("ALTER TABLE admins DROP FOREIGN KEY `$fk`");
            echo "✅ Dropped old Foreign Key '$fk'.<br>";
        }

        // Drop old column
        $pdo->exec("ALTER TABLE admins DROP COLUMN game_id");
        echo "✅ Dropped old column 'game_id'.<br>";
    } else {
        echo "ℹ️ Old column 'game_id' does not exist (Clean).<br>";
    }

    // 3. Ensure Foreign Key on assigned_game_id
    $stmt = $pdo->prepare("
        SELECT CONSTRAINT_NAME 
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'admins' AND COLUMN_NAME = 'assigned_game_id' AND REFERENCED_TABLE_NAME IS NOT NULL
    ");
    $stmt->execute([$dbName]);
    if (!$stmt->fetch()) {
        $pdo->exec("ALTER TABLE admins ADD CONSTRAINT fk_admin_assigned_game FOREIGN KEY (assigned_game_id) REFERENCES games(id) ON DELETE SET NULL");
        echo "✅ Added Foreign Key constraint to 'assigned_game_id'.<br>";
    }

    echo "<hr><strong>Migration completed successfully.</strong> <a href='index.php'>Go Home</a>";

} catch (PDOException $e) {
    echo "<div style='color:red'>Error: " . $e->getMessage() . "</div>";
}
?>