<?php
require_once '../config/database.php';

// Access Control: Super Admin only
if (($_SESSION['role'] ?? '') !== 'super') {
    die('<div class="container mt-5"><div class="alert alert-danger">Access Denied. Super Admin only. <a href="index.php">Home</a></div></div>');
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();

        // 1. Create Dummy Games
        $games = [
            ['name' => 'Chess', 'points' => 100],
            ['name' => 'Coding Marathon', 'points' => 200],
            ['name' => 'Treasure Hunt', 'points' => 150],
            ['name' => 'PubG Mobile', 'points' => 50],
            ['name' => 'Quiz', 'points' => 80],
            ['name' => 'Debate', 'points' => 120]
        ];

        foreach ($games as $g) {
            $stmt = $pdo->prepare("SELECT id FROM games WHERE game_name = ?");
            $stmt->execute([$g['name']]);
            if (!$stmt->fetch()) {
                $stmt = $pdo->prepare("INSERT INTO games (game_name, max_points) VALUES (?, ?)");
                $stmt->execute([$g['name'], $g['points']]);
            }
        }

        // 2. Create Dummy Participants
        $firstNames = ['John', 'Jane', 'Alice', 'Bob', 'Charlie', 'David', 'Eve', 'Frank', 'Grace', 'Hank'];
        $lastNames = ['Doe', 'Smith', 'Johnson', 'Brown', 'Davis', 'Miller', 'Wilson', 'Moore', 'Taylor', 'Anderson'];
        $colleges = ['MIT', 'Stanford', 'Harvard', 'Oxford', 'Cambridge', 'IIT', 'NIT'];
        $depts = ['CS', 'IT', 'ECE', 'Mech', 'Civil'];

        for ($i = 0; $i < 20; $i++) {
            $name = $firstNames[array_rand($firstNames)] . ' ' . $lastNames[array_rand($lastNames)];
            $college = $colleges[array_rand($colleges)];
            $year = rand(1, 4);
            $dept = $depts[array_rand($depts)];
            $phone = '9' . rand(100000000, 999999999);
            
            // Unique ID
            do {
                $unique_id = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 4);
                $check = $pdo->prepare("SELECT id FROM participants WHERE unique_id = ?");
                $check->execute([$unique_id]);
            } while ($check->fetch());

            $passHash = password_hash('password123', PASSWORD_DEFAULT);

            $stmt = $pdo->prepare("INSERT INTO participants (unique_id, name, college, year, department, phone, password_hash) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$unique_id, $name, $college, $year, $dept, $phone, $passHash]);
            $participant_id = $pdo->lastInsertId();

            // 3. Assign Random Points
            $gameStmt = $pdo->query("SELECT id, max_points FROM games ORDER BY RAND() LIMIT 1");
            $game = $gameStmt->fetch();
            
            if ($game) {
                $points = rand(10, $game['max_points']);
                $stmt = $pdo->prepare("INSERT INTO participant_points (participant_id, game_id, points) VALUES (?, ?, ?)");
                $stmt->execute([$participant_id, $game['id'], $points]);

                $stmt = $pdo->prepare("INSERT INTO admin_logs (admin_id, participant_id, game_id, points_given, note, ip) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$_SESSION['admin_id'], $participant_id, $game['id'], $points, 'Auto Generated', '127.0.0.1']);
            }
        }

        $pdo->commit();
        $message = "Successfully generated dummy data!";

    } catch (Exception $e) {
        $pdo->rollBack();
        $message = "Error: " . $e->getMessage();
    }
}

include '../views/header.php';
?>
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-soft">
                <div class="card-header bg-warning text-dark">
                    <h4 class="mb-0">Generate Dummy Data</h4>
                </div>
                <div class="card-body">
                    <?php if ($message): ?>
                        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                    <?php endif; ?>
                    
                    <p>This tool will:</p>
                    <ul>
                        <li>Create default games if they don't exist.</li>
                        <li>Register 20 random participants.</li>
                        <li>Assign random points to them.</li>
                    </ul>
                    <p class="text-muted">Useful for testing the leaderboard and dashboards.</p>
                    
                    <form method="POST">
                        <button type="submit" class="btn btn-warning w-100">Generate Data</button>
                    </form>
                    <br>
                    <a href="super_admin_dashboard.php" class="btn btn-outline-secondary w-100">Back to Dashboard</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include '../views/footer.php'; ?>