<?php
require_once '../config/database.php';

// Access Control
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}
if (($_SESSION['role'] ?? '') !== 'super') {
    die('<div class="container mt-5"><div class="alert alert-danger">Access Denied. Super Admin only. <a href="admin_dashboard.php">Back</a></div></div>');
}

$message = '';

// Handle Actions
if (isset($_POST['action']) && isset($_POST['request_id'])) {
    $requestId = $_POST['request_id'];
    $action = $_POST['action'];

    $stmt = $pdo->prepare("SELECT * FROM profile_edit_requests WHERE id = ?");
    $stmt->execute([$requestId]);
    $request = $stmt->fetch();

    if ($request && $request['status'] === 'pending') {
        if ($action === 'approve') {
            // Update Participant
            $updateStmt = $pdo->prepare("UPDATE participants SET name = ?, college = ?, year = ?, department = ?, phone = ? WHERE id = ?");
            $updateStmt->execute([
                $request['new_name'],
                $request['new_college'],
                $request['new_year'],
                $request['new_department'],
                $request['new_phone'],
                $request['participant_id']
            ]);
            
            // Update Request Status
            $statusStmt = $pdo->prepare("UPDATE profile_edit_requests SET status = 'approved' WHERE id = ?");
            $statusStmt->execute([$requestId]);
            $message = "Request approved and profile updated.";
        } elseif ($action === 'reject') {
            $statusStmt = $pdo->prepare("UPDATE profile_edit_requests SET status = 'rejected' WHERE id = ?");
            $statusStmt->execute([$requestId]);
            $message = "Request rejected.";
        }
    }
}

// Fetch Pending Requests
$sql = "SELECT r.*, p.name as current_name, p.unique_id 
        FROM profile_edit_requests r 
        JOIN participants p ON r.participant_id = p.id 
        WHERE r.status = 'pending' 
        ORDER BY r.created_at ASC";
$requests = $pdo->query($sql)->fetchAll();

include '../views/header.php';
?>

<div class="container">
    <h2 class="mb-4">Pending Profile Edit Requests</h2>
    
    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <div class="card shadow-soft">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Participant</th>
                            <th>Requested Changes</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($requests as $req): ?>
                        <tr>
                            <td>
                                <div class="fw-bold"><?php echo htmlspecialchars($req['current_name']); ?></div>
                                <small class="text-muted"><?php echo htmlspecialchars($req['unique_id']); ?></small>
                            </td>
                            <td>
                                <ul class="list-unstyled mb-0 small">
                                    <li><strong>Name:</strong> <?php echo htmlspecialchars($req['new_name']); ?></li>
                                    <li><strong>College:</strong> <?php echo htmlspecialchars($req['new_college']); ?></li>
                                    <li><strong>Dept:</strong> <?php echo htmlspecialchars($req['new_department']); ?> (<?php echo htmlspecialchars($req['new_year']); ?> Yr)</li>
                                    <li><strong>Phone:</strong> <?php echo htmlspecialchars($req['new_phone']); ?></li>
                                </ul>
                            </td>
                            <td><?php echo date('M d, H:i', strtotime($req['created_at'])); ?></td>
                            <td>
                                <form method="POST" class="d-flex gap-2">
                                    <input type="hidden" name="request_id" value="<?php echo $req['id']; ?>">
                                    <button type="submit" name="action" value="approve" class="btn btn-sm btn-success">Approve</button>
                                    <button type="submit" name="action" value="reject" class="btn btn-sm btn-danger">Reject</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($requests)): ?>
                            <tr><td colspan="4" class="text-center text-muted py-4">No pending requests.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../views/footer.php'; ?>