<?php
session_start();
require_once '../config/database.php';
header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$log_id = filter_var($input['log_id'] ?? 0, FILTER_VALIDATE_INT);

if (!$log_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid Log ID']);
    exit;
}

try {
    $pdo->beginTransaction();

    // Find specific log entry belonging to this admin
    $stmt = $pdo->prepare("SELECT * FROM admin_logs WHERE id = ? AND admin_id = ? FOR UPDATE");
    $stmt->execute([$log_id, $_SESSION['admin_id']]);
    $log = $stmt->fetch();

    if (!$log) {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'message' => 'Action cannot be undone (Log not found or access denied).']);
        exit;
    }

    // Revert points
    $stmt = $pdo->prepare("UPDATE participant_points SET points = points - ? WHERE participant_id = ? AND game_id = ?");
    $stmt->execute([$log['points_given'], $log['participant_id'], $log['game_id']]);

    // Remove log entry
    $stmt = $pdo->prepare("DELETE FROM admin_logs WHERE id = ?");
    $stmt->execute([$log_id]);

    $pdo->commit();
    echo json_encode(['success' => true, 'message' => 'Assignment undone successfully.']);

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    echo json_encode(['success' => false, 'message' => 'Database Error: ' . $e->getMessage()]);
}
?>